<?php
date_default_timezone_set('UTC');
include '/home/fcsus/shell/gvs_cf.php';

// === API Credentials ===
$username = 'dans@fcsus.com';
$password = '#PdC#M!9sP5T';
$base_url = 'https://guru.api.sellercloud.us/rest';

// === DB Connection ===
$pdo = new PDO("mysql:host=" . DATABASE_SERVER . ";dbname=seller_cloud_data;charset=utf8mb4", DATABASE_USER_ONE, DATABASE_PASSWORD_ONE);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $conn=mysqli_connect(DATABASE_SERVER,DATABASE_USER_ONE,DATABASE_PASSWORD_ONE,DATABASE_FCSUSDBADMIN_ORDERS);
	$conn5=mysqli_connect(DATABASE_SERVER,DATABASE_USER_ONE,DATABASE_PASSWORD_ONE,DATABASE_PRICE_APPROVAL);
	$conn3=mysqli_connect(DATABASE_SERVER,DATABASE_USER_ONE,DATABASE_PASSWORD_ONE,DATABASE_FCSUSDBADMIN_NOTIONS_DROPSHIP);
	$conn4=mysqli_connect(DATABASE_SERVER,DATABASE_USER_ONE,DATABASE_PASSWORD_ONE,DATABASE_fcsusdbadmin_B2C_greatvalue);
	$conn6=mysqli_connect(DATABASE_SERVER,DATABASE_USER_ONE,DATABASE_PASSWORD_ONE,DATABASE_GREATVAL_MORRIS_ON_HW);

class read_orders {
    public $order_db, $reports;
    public function __construct() {
        $this->order_db = mysqli_connect(DATABASE_SERVER, DATABASE_USER_ONE, DATABASE_PASSWORD_ONE, DATABASE_FCSUSDBADMIN_ORDERS);
        $this->reports = mysqli_connect(DATABASE_SERVER, DATABASE_USER_ONE, DATABASE_PASSWORD_ONE, REPORTS);
    }

    public function get_amazon_order_sku($order_id) {
        $sql = "SELECT sku FROM amazon_all_store_order WHERE amazon_order_id = '$order_id'";
        $result = mysqli_query($this->reports, $sql);
        $sku = [];
        while ($row = mysqli_fetch_assoc($result)) {
            $sku = unserialize($row['sku']);
        }
        return $sku ?? [];
    }

    public function get_ebay_sds_sku($orderID, $scid) {
        return $this->get_ebay_order_sku($orderID, $scid, ebay_sds_token_for_orders);
    }

    public function get_ebay_ec_sku($orderID, $scid) {
        return $this->get_ebay_order_sku($orderID, $scid, ebay_ec_token_for_orders);
    }

    private function get_ebay_order_sku($orderID, $scid, $token) {
        $endpoint = "https://api.ebay.com/ws/api.dll";
        $headers = [
            'X-EBAY-API-COMPATIBILITY-LEVEL:967',
            'X-EBAY-API-CALL-NAME: GetOrders',
            'X-EBAY-API-SITEID:0',
            'Content-Type: text/xml;charset=utf-8'
        ];
        $xml = "<?xml version='1.0' encoding='utf-8'?>\n";
        $xml .= "<GetOrdersRequest xmlns=\"urn:ebay:apis:eBLBaseComponents\">\n";
        $xml .= "<RequesterCredentials><eBayAuthToken>$token</eBayAuthToken></RequesterCredentials>\n";
        $xml .= "<OrderIDArray><OrderID>$orderID</OrderID></OrderIDArray>\n";
        $xml .= "<OutputSelector>OrderID</OutputSelector>\n";
        $xml .= "<OutputSelector>Item</OutputSelector>\n";
        $xml .= "<OutputSelector>QuantityPurchased</OutputSelector>\n";
        $xml .= "<OutputSelector>SellingManagerSalesRecordNumber</OutputSelector>\n";
        $xml .= "</GetOrdersRequest>";

        $ch = curl_init($endpoint);
        curl_setopt_array($ch, [CURLOPT_POST => true, CURLOPT_HTTPHEADER => $headers, CURLOPT_POSTFIELDS => $xml, CURLOPT_RETURNTRANSFER => true]);
        $response = curl_exec($ch); curl_close($ch);
        $decoded = json_decode(json_encode(simplexml_load_string($response, 'SimpleXMLElement', LIBXML_NOCDATA)), true);
        $ack = $decoded['Ack'] ?? '';
        $order = $decoded['OrderArray']['Order'] ?? [];
        $transactions = $order['TransactionArray']['Transaction'] ?? [];
        $items = [];

        if (isset($transactions['Item'])) {
            $items[] = ['sku' => $transactions['Item']['SKU'] ?? '', 'qty' => $transactions['QuantityPurchased'] ?? ''];
        } else {
            foreach ($transactions as $t) {
                $items[] = ['sku' => $t['Item']['SKU'] ?? '', 'qty' => $t['QuantityPurchased'] ?? ''];
            }
        }
        return ($ack === 'Success') ? $items : [];
    }
}

// === Utility: Calculate final dimensions ===
function get_dimension_summary($skuList, $conn) {
    $dimensions = [];
    $totalWeight = 0;

    foreach ($skuList as $item) {
        $sku = $item['sku'];
        $qty = (int)$item['qty'];
        $skuClean = str_replace('_b2b', '', $sku);
        $sql = "SELECT height, width, length, weight FROM product_weight_dimensions WHERE sku = '$sku' OR sku = '$skuClean' LIMIT 1";
        $res = mysqli_query($conn, $sql);
        if ($row = mysqli_fetch_assoc($res)) {
            $h = (float)$row['height'];
            $w = (float)$row['width'];
            $l = (float)$row['length'];
            $wt = (float)$row['weight'];
        } else {
            $h = $w = $l = $wt = 0;
        }
        $dimensions[] = ['h' => $h, 'w' => $w, 'l' => $l];
        $totalWeight += $wt * $qty;
    }

    // Girth-based logic
    $maxGirth = 0; $finalDims = ['h' => 12, 'w' => 12, 'l' => 12];
    foreach ($dimensions as $dim) {
        $h = $dim['h']; $w = $dim['w']; $l = $dim['l'];
        $girth = max($h, $w, $l) + 2 * (array_sum([$h, $w, $l]) - max($h, $w, $l));
        if ($girth > $maxGirth) {
            $maxGirth = $girth;
            $finalDims = ['h' => $h, 'w' => $w, 'l' => $l];
        }
    }

    return [
        'height' => round($finalDims['h'] ?: 12, 2),
        'width'  => round($finalDims['w'] ?: 12, 2),
        'length' => round($finalDims['l'] ?: 12, 2),
        'weight' => round($totalWeight, 2)
    ];
}

function getFedexToken() {
    $url = "https://apis.fedex.com/oauth/token";
    $data = [
        'client_id' => 'l74548e894a12047ca8e415c35bad172cb',
        'client_secret' => 'da29e46b9c2c476e9f5f5d840eba9ce4',
        'grant_type' => 'client_credentials'
    ];
    
    $curl = curl_init($url);
    curl_setopt_array($curl, [
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($data),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => ['Content-Type: application/x-www-form-urlencoded']
    ]);

    $r = curl_exec($curl);
    curl_close($curl);

    $result = json_decode($r, true);
    return $result['access_token'] ?? '';
}

function getFedexQuote($token, $weightLbs, $dimensions, $recipient, $serviceType = null) {
    $url = "https://apis.fedex.com/rate/v1/rates/quotes";

    $payload = [
        'accountNumber' => ['value' => '695007809'],
        'requestedShipment' => [
            'shipper' => [
                'address' => [
                    'streetLines' => ["259 quigley blvd", "ste 5"],
                    'city' => 'New Castle',
                    'stateOrProvinceCode' => 'DE',
                    'postalCode' => 19720,
                    'countryCode' => 'US',
                    'residential' => false
                ]
            ],
            'recipient' => [
                'address' => $recipient
            ],
            'pickupType' => 'DROPOFF_AT_FEDEX_LOCATION',
            'rateRequestType' => ['ACCOUNT'],
            'requestedPackageLineItems' => [[
                'weight' => ['units' => 'LB', 'value' => $weightLbs],
                'dimensions' => $dimensions
            ]]
        ]
    ];

    if ($serviceType) {
        $payload['requestedShipment']['serviceType'] = $serviceType;
    }

    $curl = curl_init($url);
    curl_setopt_array($curl, [
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "UTF-8",
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json;charset=UTF-8',
            'X-locale: en_US',
            'Accept-encoding: gzip',
            'Authorization: Bearer ' . $token
        ]
    ]);

    $response = curl_exec($curl);
    curl_close($curl);
    return json_decode($response, true);
}

function FedexcalculateInsurance($paid_amount) {
    if ($paid_amount > 100 && $paid_amount <= 200) return 12.95;
    if ($paid_amount > 200) return 12.95 + ceil(($paid_amount - 200) / 100) * 1.5;
    return 0;
}

function fedex_calculation($pdo, $scid,$name,$weight,$address,$city,$zip,$state,$country,$method,$height,$width,$length,$paid_amount,$type = 'ground') {

    $dimensions = [
        'length' => round($length ?: 1),
        'width' => round($width ?: 1),
        'height' => round($height ?: 1),
        'units' => "IN"
    ];

    $recipient = [
        'streetLines' => [$address],
        'city' => $city,
        'stateOrProvinceCode' => $state,
        'postalCode' => $zip,
        'countryCode' => $country,
        'residential' => true
    ];
    $token = getFedexToken();
    if (!$token) return;

    $weightLbs = round($weight / 16, 2);
    $service = $type === 'overnight' ? 'PRIORITY_OVERNIGHT' : ($type === '2day' ? 'FEDEX_2_DAY' : 'GROUND_HOME_DELIVERY');

    $response = getFedexQuote($token, $weightLbs, $dimensions, $recipient, $service);
    $cost = 1000;
    $output = $response['output']['rateReplyDetails'] ?? [];
    foreach ($output as $r) {
        if (($r['serviceType'] ?? '') === $service) {
            $cost = $r['ratedShipmentDetails'][0]['totalNetFedExCharge'] ?? 1000;
            break;
        }
    }
	

    $insurance = FedexcalculateInsurance($paid_amount);
    $cost += $insurance;

    if ($cost < 1000) {
        $shippingType = strtolower($service);
        if ($insurance > 0) $shippingType .= " + Insurance ($" . number_format($insurance, 2) . ")";

        $update = $pdo->prepare("UPDATE sellercloud_orders_tmp SET Fedex_cost = ?, Fedex_shipping_type = ? WHERE id = ?");
        $update->execute([$cost, $shippingType, $scid]);
    }
}

// === UPS Bearer Token Retrieval ===
function getBearerTokenUps() {
    $url = 'https://onlinetools.ups.com/security/v1/oauth/token';
    $credentials = base64_encode(UPS_CLIENT_ID . ':' . UPS_CLIENT_SECRET);

    $headers = [
        'Authorization: Basic ' . $credentials,
        'Content-Type: application/x-www-form-urlencoded',
    ];

    $payload = http_build_query([
        'grant_type' => 'client_credentials',
        'code' => UPS_CODE
    ]);

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_POST => 1,
        CURLOPT_POSTFIELDS => $payload,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_RETURNTRANSFER => true,
    ]);
    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true);
    return $data['access_token'] ?? null;
}

// === Main UPS Rate Calculation Function ===
function ups_calculation($pdo, $scid, $name, $weight, $address, $city, $zip, $state, $country, $method,$height,$width,$length,$paid_amount ) {
	$h=$height; 
	$w=$width; 
	$d=$length; 
	$order_total=$paid_amount;
    $weight_lbs = $weight / 16; // Convert oz to lbs
    $bearer = getBearerTokenUps();
    if (!$bearer) return;

    // Choose service code based on method
    $serviceCode = ($method === '2nd_day_air') ? "002" : "003";
    $type = ($method === '2nd_day_air') ? "ups_2nd_day_air" : "ups_ground";

    $payload = [
        "RateRequest" => [
            "Request" => ["RequestOption" => "Rate"],
            "Shipment" => [
                "Shipper" => [
                    "ShipperNumber" => "2E0164",
                    "Address" => [
                        "AddressLine" => ["243 quigley blvd, apt 12"],
                        "City" => "New Castle",
                        "StateProvinceCode" => "DE",
                        "PostalCode" => "19720",
                        "CountryCode" => "US",
                    ]
                ],
                "ShipTo" => [
                    "Address" => [
                        "AddressLine" => [$address],
                        "City" => $city,
                        "StateProvinceCode" => $state,
                        "PostalCode" => $zip,
                        "CountryCode" => $country,
                    ],
                    "ResidentialAddressIndicator" => "Y"
                ],
                "ShipFrom" => [
                    "Name" => "Return Address Name",
                    "Address" => [
                        "AddressLine1" => ["243 quigley blvd, apt 12"],
                        "City" => "New Castle",
                        "StateProvinceCode" => "DE",
                        "PostalCode" => "19720",
                        "CountryCode" => "US"
                    ]
                ],
                "Service" => ["Code" => $serviceCode],
                "Package" => [
                    "PackagingType" => ["Code" => "02"],
                    "Dimensions" => [
                        "UnitOfMeasurement" => ["Code" => "IN"],
                        "Length" => strval($d),
                        "Width"  => strval($w),
                        "Height" => strval($h)
                    ],
                    "PackageWeight" => [
                        "UnitOfMeasurement" => ["Code" => "LBS"],
                        "Weight" => strval($weight_lbs)
                    ]
                ],
                "DeliveryTimeInformation" => ["PackageBillType" => "03"],
                "ShipmentRatingOptions" => [
                    "NegotiatedRatesIndicator" => "Y",
                    "TPFCNegotiatedRatesIndicator" => "Y"
                ]
            ]
        ]
    ];

    $headers = [
        "Content-Type: application/json",
        "Authorization: Bearer $bearer",
        "transactionSrc: testing",
        "transId: 2E0164"
    ];

    $ch = curl_init("https://onlinetools.ups.com/api/rating/v1/Rate?additionalinfo=timeintransit");
    curl_setopt_array($ch, [
        CURLOPT_POST => 1,
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_RETURNTRANSFER => true,
    ]);
    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true);
    $cost = $data['RateResponse']['RatedShipment']['NegotiatedRateCharges']['TotalCharge']['MonetaryValue'] ?? null;

    if ($cost) {
        // === Add insurance fee based on subtotal ===
        $insurance = 0;
        if ($order_total > 100) {
            $insurance = 13.30 + max(0, ceil(($order_total - 200) / 100) * 1.60);
            $cost += $insurance;
        }

        // Update shipping type with insurance
        if ($insurance > 0) {
            $type .= " + Insurance Added ($" . number_format($insurance, 2) . ")";
        }

        // === Update shipping result in sellercloud_orders_tmp table ===
        $stmt = $pdo->prepare("UPDATE sellercloud_orders_tmp 
                               SET UPS_cost = :cost, 
                                   UPS_shipping_type = :type 
                               WHERE id = :scid");
        $stmt->execute([
            ':cost' => $cost,
            ':type' => $type,
            ':scid' => $scid
        ]);

        return ['cost' => $cost, 'type' => $type];
    }

    return null;
}

function getBearerToken() {
    $url = 'https://signin.stampsendicia.com/oauth/token';
    $data = [
        "grant_type" => "refresh_token",
        "client_id" => ENDICIA_CLIENT_ID,
        "client_secret" => ENDICIA_CLIENT_SECRET,
        "refresh_token" => ENDICIA_REFRESH_TOKEN,
    ];

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($data),
        CURLOPT_RETURNTRANSFER => true,
    ]);

    $result = curl_exec($ch);
    curl_close($ch);
    return json_decode($result, true);
}
function calculateInsuranceFee($valueFromRate) {
    $insuranceFees = [
        [0.01, 50.00, 0],
        [50.01, 100.00, 0],
        [100.01, 200.00, 8.15],
        [200.01, 300.00, 9.45],
        [300.01, 400.00, 10.85],
        [400.01, 500.00, 12.25],
        [500.01, 600.00, 15.00]
    ];

    foreach ($insuranceFees as $range) {
        if ($valueFromRate >= $range[0] && $valueFromRate <= $range[1]) {
            return $range[2];
        }
    }

    if ($valueFromRate > 600) {
        return 15.00 + ceil(($valueFromRate - 600) / 100) * 1.70;
    }

    return 0;
}

function usps_cal($pdo, $scid, $name, $weight, $address, $city, $zip, $state, $country, $method, $height, $width, $length, $paid_amount) {
    // Step 1: Get bearer token
    $tokenData = getBearerToken();
    $bearer_token = $tokenData['access_token'] ?? null;
    if (!$bearer_token) return ['method' => 'Bearer token error', 'cost' => 0];

    // Step 2: Build request
    $url = 'https://api.stampsendicia.com/sera/v1/rates';
    $todayDate = date("m/d/Y");
    $headers = [
        'Authorization: Bearer ' . $bearer_token,
        'Content-Type: application/json',
    ];
    $payload = [
        "from_address" => [
            "company_name" => "Fulfilment services",
            "name" => "Raghava chary",
            "address_line1" => "243 quigley blvd",
            "city" => "New Castle",
            "state_province" => "Delaware",
            "postal_code" => "19720",
            "country_code" => "US",
            "residential_indicator" => "yes",
            "phone" => "302-333-5960",
            "email" => "raghavac@fcsus.com"
        ],
        "to_address" => [
            "name" => $name,
            "address_line1" => $address,
            "city" => $city,
            "state_province" => $state,
            "postal_code" => $zip,
            "country_code" => $country,
            "residential_indicator" => "yes"
        ],
        "package" => [
            "packaging_type" => "package",
            "weight" => (float)$weight,
            "weight_unit" => "ounce",
            "length" => (float)$length,
            "width" => (float)$width,
            "height" => (float)$height,
            "dimension_unit" => "inch"
        ],
        "ship_date" => $todayDate
    ];

    // Step 3: Send request
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_HTTPHEADER => $headers,
    ]);
    $response = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);

    if ($err || !$response) {
        return ['method' => 'Curl error', 'cost' => 0];
    }

    $data = json_decode($response, true);
    $result = ["method" => "", "cost" => 0];

    foreach ($data as $item) {
			    $preferredOrder = [
				"usps_ground_advantage",
				"usps_priority_mail",
				"usps_priority_mail_international"
			];

			foreach ($preferredOrder as $preferredService) {
				foreach ($data as $item) {
					if ($item['service_type'] === $preferredService) {
						$cost = $item['shipment_cost']['total_amount'];
						$insuranceFee = calculateInsuranceFee($paid_amount);
						$cost += $insuranceFee;

						$methodType = $item['service_type'];
						if ($insuranceFee > 0) {
							$methodType .= " + Insurance Added ($" . number_format($insuranceFee, 2) . ")";
						}

						$result['method'] = $methodType;
						$result['cost'] = $cost;

						// Save to sellercloud_orders_tmp
						$stmt = $pdo->prepare("UPDATE sellercloud_orders_tmp SET usps_shipping_type = ?, usps_cost = ? WHERE id = ?");
						$stmt->execute([$methodType, $cost, $scid]);
						break 2; // Exit both loops once match is found
					}
				}
			}

    }

    return $result;
}
function usps_cal_spcl($pdo, $fpl, $name, $weight, $address, $city, $zip, $state, $country, $method, $height, $width, $length, $paid_amount) {
    $tokenData = getBearerToken();
    $bearer_token = $tokenData['access_token'] ?? null;
    if (!$bearer_token) return ['method' => 'Bearer token error', 'cost' => 0];

    $todayDate = date("m/d/Y");

    $headers = [
        "Authorization: Bearer $bearer_token",
        "Content-Type: application/json"
    ];

    $requestData = [
        "from_address" => [
            "company_name" => "Fulfilment services",
            "name" => "Raghava chary",
            "address_line1" => "243 quigley blvd",
            "city" => "New Castle",
            "state_province" => "DE",
            "postal_code" => "19720",
            "country_code" => "US",
            "residential_indicator" => "yes",
            "phone" => "302-333-5960",
            "email" => "raghavac@fcsus.com"
        ],
        "to_address" => [
            "name" => $name,
            "address_line1" => $address,
            "city" => $city,
            "state_province" => $state,
            "postal_code" => $zip,
            "country_code" => $country,
            "residential_indicator" => "yes"
        ],
        "package" => [
            "packaging_type" => "package",
            "weight" => (float)$weight,
            "weight_unit" => "ounce",
            "length" => (float)$length,
            "width" => (float)$width,
            "height" => (float)$height,
            "dimension_unit" => "inch"
        ],
        "ship_date" => $todayDate
    ];

    $ch = curl_init("https://api.stampsendicia.com/sera/v1/rates");
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($requestData),
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_RETURNTRANSFER => true
    ]);

    $response = curl_exec($ch);
    curl_close($ch);
    $data = json_decode($response, true);

    $return_response = ["method" => "", "cost" => 0];

    if (!is_array($data)) return $return_response;
    foreach ($data as $item) {
        if ($item['service_type'] === "usps_priority_mail_express") {
            $cost = $item['shipment_cost']['total_amount'];
            $insuranceFee = calculateInsuranceFee($paid_amount);
            $cost += $insuranceFee;

            $methodType = $item['service_type'];
            if ($insuranceFee > 0) {
                $methodType .= " + Insurance Added ($" . number_format($insuranceFee, 2) . ")";
            }

            $return_response = [
                "method" => $methodType,
                "cost" => $cost
            ];

            $stmt = $pdo->prepare("UPDATE sellercloud_orders_tmp SET Lowest_shipping_type = ?, Lowest_shipping_cost = ? WHERE id = ?");
            $stmt->execute([$methodType, $cost, $fpl]);

            break;
        }
    }

    return $return_response;
}


function getBestShippingOption($pdo, $scid,$name,$weight,$address,$city,$zip,$state,$country,$shippingMethod,$height,$width,$length,$paid_amount) {

    echo $method = strtolower(trim($shippingMethod));
    $isMR01 = strpos(trim($sku), 'MR01') === 0;

    // === Trigger rate APIs ===
    switch ($method) {
        case 'nextday':
        case 'secondday':
        case 'secondday-prime':
        case 'nextday-prime':
            usps_cal_spcl($pdo, $scid,$name,$weight,$address,$city,$zip,$state,$country,$method,$height,$width,$length,$paid_amount);
            fedex_calculation($pdo, $scid,$name,$weight,$address,$city,$zip,$state,$country,$method,$height,$width,$length,$paid_amount);
            ups_calculation($pdo, $scid,$name,$weight,$address,$city,$zip,$state,$country,$method,$height,$width,$length,$paid_amount);
            break;

        case 'federal express - ground':
            $cost = fedex_calculation_ground($pdo, $scid,$name,$weight,$address,$city,$zip,$state,$country,$method,$height,$width,$length,$paid_amount)['cost'] ?? '1000';
            updateLowestShipping($pdo, $scid, $cost, 'Federal Express - Ground');
            return;

        case 'fedexpriorityovernight':
            $cost = fedex_calculation($pdo, $scid,$name,$weight,$address,$city,$zip,$state,$country,$method,$height,$width,$length,$paid_amount)['cost'] ?? '1000';
            updateLowestShipping($pdo, $scid, $cost, 'FedExPriorityOvernight');
            return;

        case 'ups':
            $cost = ups_calculation($pdo, $scid,$name,$weight,$address,$city,$zip,$state,$country,$method,$height,$width,$length,$paid_amount)['cost'] ?? '1000';
            updateLowestShipping($pdo, $scid, $cost, 'UPS');
            return;
			
        default:
            fedex_calculation($pdo, $scid,$name,$weight,$address,$city,$zip,$state,$country,$method,$height,$width,$length,$paid_amount);
            ups_calculation($pdo, $scid,$name,$weight,$address,$city,$zip,$state,$country,$method,$height,$width,$length,$paid_amount);
            usps_cal($pdo, $scid,$name,$weight,$address,$city,$zip,$state,$country,$method,$height,$width,$length,$paid_amount);
            break;
    }

    // === Get rates from sellercloud_orders_tmp ===
    $stmt = $pdo->prepare("SELECT usps_cost, usps_shipping_type, Fedex_cost, Fedex_shipping_type, UPS_cost, UPS_shipping_type FROM sellercloud_orders_tmp WHERE id = ?");
    $stmt->execute([$scid]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$row) return;

    $rates = [
        'usps'  => (float)($row['usps_cost'] ?? 1000),
        'fedex' => (float)($row['Fedex_cost'] ?? 1000),
        'ups'   => (float)($row['UPS_cost'] ?? 1000),
    ];

    $methods = [
        'usps'  => $row['usps_shipping_type'] ?? 'USPS',
        'fedex' => $row['Fedex_shipping_type'] ?? 'FedEx',
        'ups'   => $row['UPS_shipping_type'] ?? 'UPS',
    ];

    // === Special condition for MR01 ===
    if ($isMR01 && $rates['fedex'] < 1000) {
        updateLowestShipping($pdo, $scid, $rates['fedex'], $methods['fedex']);
    } else {
        asort($rates); // sort by cost
        $lowestKey = key($rates);
        updateLowestShipping($pdo, $scid, $rates[$lowestKey], $methods[$lowestKey]);
    }
}

function updateLowestShipping($pdo, $scid, $cost, $method) {
    if ($cost === '' || $cost === null || $cost == 0) $cost = 1000;
    $stmt = $pdo->prepare("UPDATE sellercloud_orders_tmp SET Lowest_shipping_cost = ?, Lowest_shipping_type = ? WHERE id = ?");
    $stmt->execute([$cost, $method, $scid]);
}

function getMDSE($val, $qt) {
    // Initialize connections (reuse only required)
    $conn3 = mysqli_connect(DATABASE_SERVER, DATABASE_USER_ONE, DATABASE_PASSWORD_ONE, DATABASE_FCSUSDBADMIN_NOTIONS_DROPSHIP);
    $conn4 = mysqli_connect(DATABASE_SERVER, DATABASE_USER_ONE, DATABASE_PASSWORD_ONE, DATABASE_fcsusdbadmin_B2C_greatvalue);
    $conn5 = mysqli_connect(DATABASE_SERVER, DATABASE_USER_ONE, DATABASE_PASSWORD_ONE, DATABASE_PRICE_APPROVAL);

    $clean_sku = str_replace("_b2b", '', $val);
    $mdse = 0;

    $tables = [
        ['table' => 'notions_sd300_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'fcsus_vendor_net_price', 'freight' => 'inward_freight']],
        ['table' => 'notions_sd300_op', 'conn' => $conn3, 'fields' => ['sku' => $val, 'price' => 'fcsus_vendor_net_price', 'freight' => 'inward_freight']],
        ['table' => 'notions_sd300_op', 'conn' => $conn3, 'fields' => ['notions_uos_sku' => $val, 'price' => 'notions_uos_vnp', 'freight' => 'inward_freight']],
        ['table' => 'buy_season_op', 'conn' => $conn3, 'fields' => ['sku' => $val, 'price' => 'fcsus_vendor_net_price', 'freight' => 'inward_freight']],
        ['table' => 'hd_supply_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'fcsus_vendor_net_price', 'freight' => 'inward_freight']],
        ['table' => 'grainger_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'fcsus_vendor_net_price', 'freight' => 'inward_freight']],
        ['table' => 'KW01_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'fcsus_vendor_net_price', 'freight' => 'inward_freight']],
        ['table' => 'PET_b2b_op', 'conn' => $conn5, 'fields' => ['sku' => $val, 'price' => 'vendor_net_price', 'freight' => 'inward_freight']],
        ['table' => 'bosspetedge_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'fcsus_vendor_net_price', 'freight' => 'inward_freight']],
        ['table' => 'andis_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'vnp', 'freight' => 'inward_freight']],
        ['table' => 'bigalspet_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'vnp', 'freight' => 'inward_freight']],
        ['table' => 'cardinalgates_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'vnp', 'freight' => 'inward_freight']],
        ['table' => 'coastalpet_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'vnp', 'freight' => 'inward_freight']],
        ['table' => 'dgspet_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'vnp', 'freight' => 'inward_freight']],
        ['table' => 'fleakillerguys_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'vnp', 'freight' => 'inward_freight']],
        ['table' => 'gopet_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'vnp', 'freight' => 'inward_freight']],
        ['table' => 'Groomersmall_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'notions_vnp', 'freight' => 'inward_freight']],
        ['table' => 'jefferpet_op_new', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'notions_vnp', 'freight' => 'inward_freight']],
        ['table' => 'jollypets_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'fcsus_vendor_net_price', 'freight' => 'inward_freight']],
        ['table' => 'laubeshop_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'vnp', 'freight' => 'inward_freight']],
        ['table' => 'lllreptile_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'vnp', 'freight' => 'inward_freight']],
        ['table' => 'petgear_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'vnp', 'freight' => 'inward_freight']],
        ['table' => 'prevuepet_dropship_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'dropship_cost', 'freight' => 'inward_freight']],
        ['table' => 'ryanspet_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'notions_vnp', 'freight' => 'inward_freight']],
        ['table' => 'Essential_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'fcsus_vendor_net_price', 'freight' => 'inward_freight']],
        ['table' => 'notions_sd300_website', 'conn' => $conn3, 'fields' => ['sku' => $val, 'price' => 'fcsus_vendor_net_price', 'freight' => 'inward_freight']],
        ['table' => 'notions_sd300_fbm', 'conn' => $conn3, 'fields' => ['sku' => $val, 'price' => 'fcsus_vendor_net_price', 'freight' => 'inward_freight']],
        ['table' => 'leemarpet_op', 'conn' => $conn3, 'fields' => ['sku' => $val, 'price' => 'fcsus_vendor_net_price', 'freight' => 'inward_freight']],
        ['table' => 'leemarpet_op', 'conn' => $conn3, 'fields' => ['sku' => $clean_sku, 'price' => 'fcsus_vendor_net_price', 'freight' => 'inward_freight']],
        ['table' => 'b2c_greatvalue_fbm', 'conn' => $conn4, 'fields' => ['Our_productID' => $val, 'price' => 'Vendor_Net_Price', 'freight' => 'Inward_freight']],
        ['table' => 'morris_op', 'conn' => $conn3, 'fields' => ['sku' => $val, 'price' => 'price', 'freight' => 'inward_freight']],
    ];

    foreach ($tables as $entry) {
        $conn = $entry['conn'];
        $table = $entry['table'];
        $column = array_keys($entry['fields'])[0];
        $sku_value = $entry['fields'][$column];
        $price_col = $entry['fields']['price'];
        $freight_col = $entry['fields']['freight'];

        $qry = "SELECT `$price_col`, `$freight_col` FROM `$table` WHERE `$column` = '" . mysqli_real_escape_string($conn, $sku_value) . "' LIMIT 1";
        $res = mysqli_query($conn, $qry);
        if ($r = mysqli_fetch_array($res)) {
            $vnp = floatval($r[$price_col]);
            $inv_fr = floatval($r[$freight_col]);
            $mdse = ($vnp + $inv_fr) * $qt;
            break;
        }
    }

    return $mdse;
}

function calculateSimpleMDSE($conn5, $conn3, $sku, $qty) {
    $sku_clean = str_replace("_b2b", '', $sku);
    $tables = [
        "price_approval.all_price_approval_NM01_new",
        "price_approval.all_price_approval_new",
        "product_master_catalog_NM01",
        "product_master_catalog",
        "all_prices_fbm_11_state_prime_NM01",
        "all_prices_fbm_11_state_prime",
        "all_price_PET_b2b"
    ];

    foreach ($tables as $table) {
        $qry = "SELECT Vendor_Net_Price, Inward_freight FROM `$table` WHERE sku = '$sku' OR sku = '$sku_clean' LIMIT 1";
        $res = mysqli_query($conn5, $qry);
        if ($res && $r = mysqli_fetch_array($res)) {
            $vnp = (float)$r['Vendor_Net_Price'];
            $fr = (float)$r['Inward_freight'];
            $mdse = ($vnp + $fr) * $qty;
            $note = "$sku | $table  | Qty: $qty | VNP: $vnp | Freight: $fr | Subtotal: $mdse";
            return [$mdse, $note];
        }
    }

    // Fallback to notions_sd300_op
    $qry = "SELECT fcsus_vendor_net_price AS Vendor_Net_Price, inward_freight FROM notions_sd300_op WHERE sku = '$sku_clean' LIMIT 1";
    $res = mysqli_query($conn3, $qry);
    if ($res && $r = mysqli_fetch_array($res)) {
        $vnp = (float)$r['Vendor_Net_Price'];
        $fr = (float)$r['inward_freight'];
        $mdse = ($vnp + $fr) * $qty;
        $note = "$sku | notions_sd300_op  | Qty: $qty | VNP: $vnp | Freight: $fr | Subtotal: $mdse";
        return [$mdse, $note];
    }

    // Final fallback
    $fallback_mdse = getMDSE($sku, $qty);
    $note = "SKU: $sku | Qty: $qty | Subtotal: $fallback_mdse";
    return [$fallback_mdse, $note];
}




// === Authenticate ===
$auth_payload = json_encode(['Username' => $username, 'Password' => $password]);
$ch = curl_init("$base_url/api/token");
curl_setopt_array($ch, [CURLOPT_RETURNTRANSFER => true, CURLOPT_POST => true, CURLOPT_POSTFIELDS => $auth_payload, CURLOPT_HTTPHEADER => ['Content-Type: application/json']]);
$auth_response = curl_exec($ch); curl_close($ch);
$access_token = json_decode($auth_response, true)['access_token'] ?? null;
if (!$access_token) die("❌ Auth failed\n");

// === Fetch orders ===
$from = date('Y-m-d\TH:i:s', strtotime('-3 days'));
$to = date('Y-m-d\TH:i:s');
$targetSCIDs = [5006545];
$orderSourceMap = [1 => 'ebay', 4 => 'amazon', 6 => 'website', 15 => 'magento', 50 => 'walmart'];
$reader = new read_orders();
$all_orders = []; $page = 1;

do {
    $url = "$base_url/api/orders?pageNumber=$page&pageSize=50&CreatedOnDateFrom=$from&CreatedOnDateTo=$to";
    $ch = curl_init($url);
    curl_setopt_array($ch, [CURLOPT_RETURNTRANSFER => true, CURLOPT_HTTPHEADER => ["Authorization: Bearer $access_token", "Content-Type: application/json"]]);
    $result = curl_exec($ch); curl_close($ch);
    $data = json_decode($result, true);
    $orders = $data['Items'] ?? [];
    if (!$orders) break;
    $all_orders = array_merge($all_orders, $orders);
    $page++;
} while (count($orders) === 50);

// === Insert and Enrich ===
foreach ($all_orders as $order) {
    //if (!in_array($order['ID'], $targetSCIDs)) continue;
	$scid = $order['ID'];
    $check = $pdo->prepare("SELECT calculation_done FROM sellercloud_orders_tmp WHERE id = :id LIMIT 1");
	$check->execute([':id' => $scid]);
	$row = $check->fetch();

	if ($row && (int)$row['calculation_done'] === 1) {
		echo "⏩ Skipping SCID: $scid (already Calculated)\n";
		continue;
	}
    
    $orderSource = $orderSourceMap[$order['OrderSource']] ?? 'unknown';
    $company = strtolower($order['CompanyName'] ?? '');
    $sourceOrderID = $order['OrderSourceOrderID'];
    $shipping = serialize($order['ShippingAddress'] ?? []);
    $billing = serialize($order['BillingAddress'] ?? []);
    $minimalItems = [];
	foreach ($order['Items'] ?? [] as $item) {
		if (!empty($item['ProductID']) && isset($item['Qty'])) {
			$minimalItems[] = [
				'sku' => $item['ProductID'],
				'qty' => (int)$item['Qty']
			];
		}
	}
	$items = serialize($minimalItems);
    $stmt = $pdo->prepare("INSERT INTO sellercloud_orders_tmp (
        id, order_source_order_id, customer_email, company_name, order_source,
        time_of_order, customer_name, shipping_address, billing_address,
        grand_total, shipping_total, tax_total, paid_amount, balance, items,
        shipping_carrier, shipping_service, destination_state, destination_country, destination_zip
    ) VALUES (
        :id, :osid, :email, :company, :source, :time, :name, :ship, :bill,
        :total, :shiptotal, :taxtotal, :paid, :balance, :items,
        :carrier, :service, :state, :country, :zip
    ) ON DUPLICATE KEY UPDATE customer_email=VALUES(customer_email), company_name=VALUES(company_name),
    order_source=VALUES(order_source), time_of_order=VALUES(time_of_order), customer_name=VALUES(customer_name),
    shipping_address=VALUES(shipping_address), billing_address=VALUES(billing_address), grand_total=VALUES(grand_total),
    shipping_total=VALUES(shipping_total), tax_total=VALUES(tax_total), paid_amount=VALUES(paid_amount),
    balance=VALUES(balance), items=VALUES(items), shipping_carrier=VALUES(shipping_carrier),
    shipping_service=VALUES(shipping_service), destination_state=VALUES(destination_state),
    destination_country=VALUES(destination_country), destination_zip=VALUES(destination_zip)");

    $stmt->execute([
        ':id' => $scid,
        ':osid' => $sourceOrderID,
        ':email' => $order['CustomerEmail'] ?? '',
        ':company' => $order['CompanyName'] ?? '',
        ':source' => $orderSource,
        ':time' => $order['TimeOfOrder'] ?? '',
        ':name' => trim(($order['FirstName'] ?? '') . ' ' . ($order['LastName'] ?? '')),
        ':ship' => $shipping,
        ':bill' => $billing,
        ':total' => $order['GrandTotal'] ?? 0,
        ':shiptotal' => $order['ShippingTotal'] ?? 0,
        ':taxtotal' => $order['TaxTotal'] ?? 0,
        ':paid' => $order['Payments'][0]['PaidAmount'] ?? 0,
        ':balance' => round(($order['GrandTotal'] ?? 0) - ($order['Payments'][0]['PaidAmount'] ?? 0), 2),
        ':items' => $items,
        ':carrier' => $order['ShippingCarrier'] ?? '',
        ':service' => $order['ShippingService'] ?? '',
        ':state' => $order['ShippingAddress']['StateCode'] ?? '',
        ':country' => $order['ShippingAddress']['CountryCode'] ?? '',
        ':zip' => $order['ShippingAddress']['PostalCode'] ?? ''
    ]);

    echo "✅ Inserted SCID: $scid\n";

    // === Marketplace SKU Fetch ===
    $skuData = [];
    if ($orderSource === 'amazon') {
        $skuData = $reader->get_amazon_order_sku($sourceOrderID);
    } elseif ($orderSource === 'ebay') {
        $skuData = strpos($company, 'exclusive') !== false ? $reader->get_ebay_ec_sku($sourceOrderID, $scid) : $reader->get_ebay_sds_sku($sourceOrderID, $scid);
    }

    $enriched = [];
    foreach ($skuData as $item) {
        $sku = $item['sku']; $qty = (int)$item['qty']; $weight = 0;
        $skuClean = str_replace('_b2b', '', $sku);
        $sql = "SELECT weight FROM product_weight_dimensions WHERE sku = '$sku' OR sku = '$skuClean' LIMIT 1";
        $res = mysqli_query($reader->order_db, $sql);
        if ($row = mysqli_fetch_assoc($res)) $weight = (float)sprintf('%.2f', $row['weight']);
        $enriched[] = ['sku' => $sku, 'qty' => $qty, 'weight' => $weight, 'total_weight' => (float)($qty * $weight)];
    }

    if ($enriched) {
        $field = ($orderSource === 'amazon') ? 'amazon_items' : 'ebay_items';
        $stmt = $pdo->prepare("UPDATE sellercloud_orders_tmp SET $field = :data WHERE id = :id");
        $stmt->execute([':data' => serialize($enriched), ':id' => $scid]);
        echo "📦 $field updated for SCID: $scid\n";
    }

    // === Final Dimension Calculation ===
    $itemList = $enriched ?: array_map(function ($i) {
        return ['sku' => $i['ProductID'] ?? '', 'qty' => $i['qty'] ?? 1];
    }, $order['Items'] ?? []);
    $dimData = get_dimension_summary($itemList, $reader->order_db);
	
    $stmt = $pdo->prepare("UPDATE sellercloud_orders_tmp SET dimension_height = :h, dimension_width = :w, dimension_length = :l, total_weight = :wt WHERE id = :id");
    $stmt->execute([
        ':h' => $dimData['height'], ':w' => $dimData['width'],
        ':l' => $dimData['length'], ':wt' => $dimData['weight'], ':id' => $scid
    ]);
    echo "📐 Dimensions updated for SCID: $scid\n";	
}
$skuRates = [
    'KW01' => 10.00,
    'LM01' => 8.00,
    'PV01' => 5.00,
    'BP01' => 10.00,
    'JP01' => 10.00,
    'RP01' => 15.00,
    'PG01' => 10.00,
    'ES01' => 5.00,
    'WI01' => 13.50,
];

// === Get all orders
$stmt = $pdo->query("SELECT id, Items, amazon_items, ebay_items, destination_state, destination_country, destination_zip, shipping_service, total_weight,paid_amount,dimension_height,dimension_width,dimension_length,shipping_address  FROM sellercloud_orders_tmp where Lowest_shipping_type IS NULL OR Lowest_shipping_type = ''");
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

// === Process Each Order
foreach ($orders as $order) {
	
    $scid = $order['id'];
    $skuJson = $order['amazon_items'] ?? $order['ebay_items'] ?? $order['Items'];
    if (!$skuJson) continue;

    $skuData = @unserialize($skuJson);
    if (!is_array($skuData)) continue;

    $updated = false;

    foreach ($skuData as $item) {
        $sku = trim($item['sku'] ?? $item['ProductID'] ?? '');
        if ($sku === '' || strpos($sku, '_b2b') !== false) continue;

        // Match SKU with prefix
        foreach ($skuRates as $prefix => $rate) {
            if (strpos($sku, $prefix) !== false) {
                $update = $pdo->prepare("UPDATE sellercloud_orders_tmp SET Lowest_shipping_cost = :cost, Lowest_shipping_type = 'Fixed shipping cost' WHERE id = :id");
                $update->execute([':cost' => $rate, ':id' => $scid]);
                $updated = true;
                break 2; // break both loops
            }
        }
    }

    if ($updated) {
        echo "✅ SCID $scid shipping cost updated.\n";
    }

	if (!$updated) {
		$serialized = $order['shipping_address'];

		// Safely unserialize
		$shipping = @unserialize($serialized);
		if (!is_array($shipping)) {
			echo "❌ SCID $scid: Invalid serialized shipping_address\n";
			continue;
		}
		$scid = $order['id'] ?? '';
		$shippingMethod = strtolower(trim($order['shipping_service'] ?? ''));
		$zip    = $order['destination_zip'] ?? '';
		$state  = $order['destination_state'] ?? '';
		$country= $order['destination_country'] ?? '';
		$weight = (float)($order['total_weight'] ?? 0);
		$firstName = $shipping['FirstName'] ?? '';
		$lastName  = $shipping['LastName'] ?? '';
		$name      = trim("$firstName $lastName");
		$address   = $shipping['StreetLine1'] ?? '';
		$city      = $shipping['City'] ?? '';
		$paid_amount=$order['paid_amount'] ?? '';
		$height =$order['dimension_height'] ?? '';
		$width=$order['dimension_width'] ?? '';
		$length=$order['dimension_length'] ?? '';
		getBestShippingOption($pdo,$scid,$name,$weight,$address,$city,$zip,$state,$country,$shippingMethod,$height,$width,$length,$paid_amount);
	}
}

$stmt = $pdo->query("SELECT id, order_source, items, amazon_items, ebay_items FROM sellercloud_orders_tmp where calculation_done IS NULL OR calculation_done = 0");
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

$result = [];

foreach ($rows as $row) {
    $orderId = $row['id'];
    $source = strtolower(trim($row['order_source']));
    
    // Decide which field to use based on source
    if ($source === 'ebay') {
        $data = $row['ebay_items'];
    } elseif ($source === 'amazon') {
        $data = $row['amazon_items'];
    } else {
        $data = $row['items'];
    }

    $items = @unserialize($data);
    if (!is_array($items)) continue;

    $skuQty = [];

    foreach ($items as $entry) {
        if (is_array($entry) && !empty($entry['sku']) && isset($entry['qty'])) {
            $sku = $entry['sku'];
            $qty = (int)$entry['qty'];
            if ($qty > 0) {
                $skuQty[$sku] = $qty;
            }
        }
    }

    if (!empty($skuQty)) {
        $result[$orderId] = $skuQty;
    }
}

foreach ($result as $orderId => $skuQtyArr) {
    $mdse = 0;
	$notes = "";
	foreach ($skuQtyArr as $sku => $qty) {
		list($sku_mdse, $sku_note) = calculateSimpleMDSE($conn5, $conn3, $sku, $qty);
		$mdse += $sku_mdse;
		$notes .= $sku_note . PHP_EOL;
	}
	$notes .= "Total MDSE Subtotal: " . round($mdse, 2);

    $stmt = $pdo->prepare("SELECT grand_total, order_source, Lowest_shipping_cost,tax_total FROM sellercloud_orders_tmp WHERE id = :id");
    $stmt->execute([':id' => $orderId]);
    $order = $stmt->fetch(PDO::FETCH_ASSOC);

    $sub_total = (float)$order['grand_total']-$order['tax_total'];
    $market = strtoupper(trim($order['order_source']));
    $Lowest_shipping_cost = (float)$order['Lowest_shipping_cost'];

    $ref_fee = 0;
    $totcal_cost = 0;

    // 3. Calculate ref_fee and total cost
    if ($market == 'MAGENTO' || $market === 'DOBA') {
        $totcal_cost = $mdse + $Lowest_shipping_cost;
    } elseif ($market == 'GEX') {
        $ref_fee = $sub_total * 0.12;
        $totcal_cost = $mdse + $Lowest_shipping_cost + $ref_fee;
    } elseif ($market == 'EBAY' ) {
        $ref_fee = $sub_total * 0.17;
        $totcal_cost = $mdse + $Lowest_shipping_cost + $ref_fee;
    } else {
        $ref_fee = $sub_total * 0.16;
        $totcal_cost = $mdse + $Lowest_shipping_cost + $ref_fee;
    }

    // 4. Determine outcome
    $outcome = ($sub_total - $totcal_cost >= 0) ? 'Profit' : 'Loss';
    $price_difference = $sub_total - $totcal_cost;
    // 5. Update record
			$stmt = $pdo->prepare("UPDATE sellercloud_orders_tmp 
		SET mdse = :mdse, ref_fee = :ref_fee, outcome = :outcome, price_difference = :price_difference, notes = :notes ,calculation_done = 1
		WHERE id = :id");

		$stmt->execute([
			':mdse' => round($mdse, 2),
			':ref_fee' => round($ref_fee, 2),
			':outcome' => $outcome,
			':price_difference' => round($price_difference, 2),
			':notes' => $notes,
			':id' => $orderId
		]);

echo "✅ Order $orderId → MDSE: $mdse | Ref Fee: $ref_fee | Outcome: $outcome | Diff: $price_difference\n";
echo "📋 Notes:\n$notes\n";

}

function getStatusFromSKU($sku) {
    if (str_ends_with($sku, '_b2b')) return null;
    if (strpos($sku, 'NM01') !== false) return 'Notions Cart';
    if (strpos($sku, 'LM01') !== false) return 'LM01 Orders';
    if (strpos($sku, 'KW01') !== false) return 'KW01 Orders';
    if (strpos($sku, 'ES01') !== false) return 'ES01 Orders';
    if (strpos($sku, 'SM01') !== false) return 'SM01 Orders';
    if (strpos($sku, 'WI01') !== false) return 'WI01 Orders';
    if (strpos($sku, 'MR01') !== false) return 'MR01 Orders';
    return null;
}

function str_ends_with($haystack, $needle) {
    return substr($haystack, -strlen($needle)) === $needle;
}

function getInventoryQty($sku) {
    global $access_token;
     if ($sku === 'handlingfee') {
        return 1;
    }

    // === Return 1 for specific prefixes (if not ending in _b2b)
    $prefixes = ['NM01', 'LM01', 'KW01', 'ES01', 'SM01', 'WI01', 'MR01'];

    foreach ($prefixes as $prefix) {
        if (strpos($sku, $prefix) !== false && !str_ends_with($sku, '_b2b')) {
            return 1;
        }
    }

    // === Normal inventory API call
    $base_url = 'https://guru.api.sellercloud.us/rest';
    $url = $base_url . '/api/Inventory/Details?productID=' . urlencode($sku);

    $headers = [
        'Authorization: Bearer ' . $access_token,
        'Content-Type: application/json',
        'Accept: application/json'
    ];

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => $headers
    ]);
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_code === 200) {
        $data = json_decode($response, true);
        return $data['Inventory']['AggregateQty'] ?? 0;
    }

    return 0; // fallback if API fails
}



$sql = "SELECT id, amazon_items, ebay_items, items,
               grand_total AS sub_total, mdse, ref_fee, Lowest_shipping_cost, Lowest_shipping_type,
               dimension_height, dimension_width, dimension_length, total_weight,
               outcome, price_difference, destination_country, destination_state
        FROM sellercloud_orders_tmp
        WHERE custom_status_calculated = 0 ";

$stmt = $pdo->query($sql);
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($orders as $order) {
    $id = $order['id'];

    $skuList = [];
    foreach (['amazon_items', 'ebay_items', 'items'] as $field) {
        if (!empty($order[$field])) {
            $items = @unserialize($order[$field]);
            if (is_array($items)) {
                foreach ($items as $item) {
                    if (!empty($item['sku'])) $skuList[] = $item['sku'];
                }
            }
            if (!empty($skuList)) break;
        }
    }
    if (empty($skuList)) continue;

    $sub_total = (float)($order['sub_total'] ?? 0);
    $mdse = (float)($order['mdse'] ?? 0);
    $ref_fee = (float)($order['ref_fee'] ?? 0);
    $ship_cost = (float)($order['Lowest_shipping_cost'] ?? 0);
    $ship_type = $order['Lowest_shipping_type'] ?? 'N/A';
    $height = $order['dimension_height'] ?? '0.00';
    $width  = $order['dimension_width'] ?? '0.00';
    $length = $order['dimension_length'] ?? '0.00';
    $weight = $order['total_weight'] ?? '0.00';
    $outcome = strtolower($order['outcome'] ?? '');
    $price_diff = (float)$order['price_difference'];
    $dest_country = strtoupper(trim($order['destination_country'] ?? ''));
    $dest_state   = strtoupper(trim($order['destination_state'] ?? ''));

    $total_cost = $mdse + $ship_cost + $ref_fee;
    $c_difference = ($sub_total > 0) ? abs($price_diff / $sub_total) * 100 : 0;
    $_difference = abs($price_diff);

    $allQty = [];
	$outOfStockSKUs = [];

	foreach ($skuList as $skuCheck) {
		$qty = getInventoryQty($skuCheck);
		$allQty[$skuCheck] = $qty;
		if ($qty <= 0) {
			$outOfStockSKUs[] = $skuCheck;
		}
	}

	$allOut  = count($outOfStockSKUs) === count($allQty);
	$someOut = count($outOfStockSKUs) > 0 && !$allOut;

	$note_parts = [];
	$note_parts[] = "Outcome: " . ucfirst($outcome);
	$note_parts[] = "Order Subtotal: $" . number_format($sub_total, 2);
	$note_parts[] = "Shipping: {$ship_type} $" . number_format($ship_cost, 2);
	$note_parts[] = "Fee: $" . number_format($ref_fee, 2);
	$note_parts[] = "Total Cost: $" . number_format($total_cost, 2);
	$note_parts[] = "Diff: " . (($price_diff >= 0) ? "+" : "-") . "$" . number_format(abs($price_diff), 2);
	$note_parts[] = "Dim: {$height}\"x{$width}\"x{$length}\" @ {$weight} oz";

	// === Set status and append notes
	if ($allOut) {
        $status = 'Review For Cancellation';
		$note_parts[] = "All SKUs out of stock: " . implode(', ', $outOfStockSKUs);
	} elseif ($someOut) {
		$status = 'Rams Review';
		$note_parts[] = "Out of stock SKUs: " . implode(', ', $outOfStockSKUs);
	} elseif ($dest_country !== 'US' || in_array($dest_state, ['HI', 'VI']) || $sub_total >= 100) {
		$status = 'Management Review';
	} elseif ($ship_cost <= 0) {
		$status = 'Price Review';
		$note_parts[] = "No shipping method found.";
	} elseif ($outcome === 'loss') {
		if ($c_difference > 10 && $_difference > 2) {
			$status = 'Review For Cancellation';
		} elseif (
			($c_difference > 10 && $_difference <= 2) ||
			($c_difference >= 5 && $c_difference <= 10) ||
			($c_difference <= 5)
		) {
			$status = 'Price Review';
		}
	} elseif ($outcome === 'profit') {
		if ($total_cost < 30) {
			$status = 'In Process';
			foreach ($skuList as $skuCheck) {
				$match = getStatusFromSKU($skuCheck);
				if (!empty($match)) {
					$status = $match;
					break;
				}
			}
		} else {
			$status = 'Special Care';
		}
	} else {
		$status = 'Special Care';
		foreach ($skuList as $skuCheck) {
			$match = getStatusFromSKU($skuCheck);
			if (!empty($match)) {
				$status = $match;
				break;
			}
		}
	}

	// === Final note string
	$note = implode(' | ', $note_parts);

	

    $update = $pdo->prepare("UPDATE sellercloud_orders_tmp 
        SET custom_status = :status, custom_status_notes = :note, custom_status_calculated = 1 
        WHERE id = :id");
    $update->execute([
        ':status' => $status,
        ':note' => $note,
        ':id' => $id
    ]);

    echo "✅ Updated ID {$id} with {$status}\n";
}

$customStatusMap = [
    "Management Review" => "ManagementReview",
    "Price Review" => "PriceReview",
    "Review For Cancellation" => "ReviewForCancellation",
    "Pending" => "Pending",
    "DropShip" => "DropShip",
    "To Be Reviewed" => "ToBeReviewed",
    "Special Care" => "SpecialCare",
    "Ordered To Notions" => "OrderedToNotions",
    "Notions Cart" => "NotionsCart",
    "Amirs Review" => "AmirsReview",
    "KW01 Orders" => "KW01Orders",
    "KW01 Dropship" => "KW01Dropship",
    "ES01 Orders" => "ES01Orders",
    "Ordered To ES01" => "OrderedToES01",
    "No Action Require" => "NoActionRequire",
    "BP01 Orders" => "BP01Orders",
    "Ordered To BP01" => "OrderedToBP01",
    "Fatemas Review" => "FatemasReview",
    "BuySeason Ready Orders" => "BuySeasonReadyOrders",
    "Ordered To RP01" => "OrderedToRP01",
    "RP01 Order" => "RP01Order",
    "PV01 Order" => "PV01Order",
    "PV01 Dropship Order" => "PV01DropshipOrder",
    "Rams Review" => "RamsReview",
    "Refund Required" => "RefundRequired",
    "Dispatch Team" => "DispatchTeam",
    "Ajay Bandekar" => "AjayBandekar",
    "Marketplace Claims" => "MarketplaceClaims",
    "MorrisReady Orders" => "MorrisReadyOrders",
    "MR01 Orders" => "MorrisReadyOrders",
    "Partial Inventory" =>"RamsReview",
	"In Process" =>"InProcess",
    "SM01 Orders" =>"SM01OrdersOnly",	// alias mapping
];


// === Step 2: Get Orders from DB ===
$sql = "SELECT id, notes, custom_status_notes, custom_status FROM sellercloud_orders_tmp WHERE custom_status_pushed = 0";
$stmt = $pdo->query($sql);
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($orders)) {
    die("ℹ️ No orders found to push notes.\n");
}

// === Step 3: Process each order ===
foreach ($orders as $row) {
    $orderId = $row['id'];
    $statusLabel = trim($row['custom_status']);
    $statusValue = $customStatusMap[$statusLabel] ?? null;

    if (!$statusValue) {
        echo "⚠️ Skipping Order $orderId: Unknown custom status \"$statusLabel\"\n";
        continue;
    }

    
	$noteMessage = trim("$statusLabel | {$row['notes']} | {$row['custom_status_notes']}");

    // === Step 3a: Push Note ===
    $note_url = "https://guru.api.sellercloud.us/rest/api/Orders/$orderId/Notes";
    $noteData = [
        "Message"   => $noteMessage,
        "Category"  => 0,
        "IsPinned"  => true
    ];
    $note_payload = json_encode($noteData);
    $note_headers = [
        "Content-Type: application/json",
        "Accept: application/json",
        "Authorization: Bearer $access_token"
    ];

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $note_url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $note_payload,
        CURLOPT_HTTPHEADER => $note_headers
    ]);
    $note_response = curl_exec($ch);
    $note_http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($note_http_code !== 200 && $note_http_code !== 201) {
        echo "❌ Failed to add note to order $orderId. HTTP $note_http_code\n$note_response\n";
        continue;
    }

    // === Step 3b: Update Custom Column ===
    $custom_column_url = "https://guru.api.sellercloud.us/rest/api/Orders/$orderId/CustomColumns/Multiple";
    $custom_column_payload = json_encode([
        ["ColumnName" => "CUSTOMEORDERSTATUS", "Value" => $statusValue]
    ]);

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $custom_column_url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => "PUT",
        CURLOPT_POSTFIELDS => $custom_column_payload,
        CURLOPT_HTTPHEADER => $note_headers
    ]);
    $custom_response = curl_exec($ch);
    $custom_http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($custom_http_code === 200 || $custom_http_code === 204) {
        // Mark as pushed in DB
        $upd = $pdo->prepare("UPDATE sellercloud_orders_tmp SET custom_status_pushed = 1 WHERE id = :id");
        $upd->execute([':id' => $orderId]);
        echo "✅ Order $orderId: Note + Custom Status pushed.\n";
    } else {
        echo "❌ Failed to update custom column for order $orderId. HTTP $custom_http_code\n$custom_response\n";
    }
}




