<?php
// === Step 1: Authenticate ===
$username = 'dans@fcsus.com';
$password = '#PdC#M!9sP5T';
$auth_url = 'https://guru.api.sellercloud.us/rest/api/token';

$auth_payload = json_encode([
    'Username' => $username,
    'Password' => $password
]);

$auth_headers = [
    'Content-Type: application/json',
    'Content-Length: ' . strlen($auth_payload)
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $auth_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $auth_payload);
curl_setopt($ch, CURLOPT_HTTPHEADER, $auth_headers);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code !== 200) {
    die("❌ Auth failed. HTTP Code: $http_code\n$response\n");
}

$data = json_decode($response, true);
$access_token = $data['access_token'];

// === Step 2: Get Order Notes ===
$order_id = 5006545;
$notes_url = "https://guru.api.sellercloud.us/rest/api/orders/notes?id=$order_id";

$headers = [
    "Content-Type: application/json",
    "Authorization: Bearer $access_token"
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $notes_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPGET, true);  // explicitly GET
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code == 200) {
    echo "✅ Successfully retrieved notes for order $order_id:\n\n";
    $notes = json_decode($response, true);
    foreach ($notes as $note) {
        echo "📌 NoteID: " . $note['NoteID'] . "\n";
        echo "📝 Note: " . $note['Note'] . "\n";
        echo "👤 Created By: " . $note['CreatedByName'] . " (" . $note['CreatedByEmail'] . ")\n";
        echo "📅 Date: " . $note['AuditData'] . "\n";
        echo "-------------------------\n";
    }
} else {
    echo "❌ Failed to fetch notes. HTTP Code: $http_code\n$response\n";
}
?>
