<?php
date_default_timezone_set('UTC');
include '/home/fcsus/shell/gvs_cf.php';

$username = 'dans@fcsus.com';
$password = '#PdC#M!9sP5T';
$base_url = 'https://guru.api.sellercloud.us/rest';
$auth_url = $base_url . '/api/token';
$order_url = $base_url . '/api/orders';

$host = DATABASE_SERVER;
$dbname = 'seller_cloud_data';
$user = DATABASE_USER_ONE;
$pass = DATABASE_PASSWORD_ONE;

$pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// === Step 1: Authenticate ===
$auth_payload = json_encode(['Username' => $username, 'Password' => $password]);
$auth_headers = [
    'Content-Type: application/json',
    'Content-Length: ' . strlen($auth_payload)
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $auth_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $auth_payload);
curl_setopt($ch, CURLOPT_HTTPHEADER, $auth_headers);
$response = curl_exec($ch);
curl_close($ch);

$auth_data = json_decode($response, true);
if (!isset($auth_data['access_token'])) {
    die("Authentication failed:\n$response");
}
$access_token = $auth_data['access_token'];

// === Step 2: Fetch Orders (Last 15 Days) ===
$from = date('Y-m-d\TH:i:s', strtotime('-15 days'));
$to = date('Y-m-d\TH:i:s');
$page = 1;
$pageSize = 50;
$all_orders = [];

do {
    $url = "$order_url?pageNumber=$page&pageSize=$pageSize&CreatedOnDateFrom=$from&CreatedOnDateTo=$to";
    $order_headers = [
        "Authorization: Bearer $access_token",
        "Content-Type: application/json"
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $order_headers);
    $response = curl_exec($ch);
    curl_close($ch);

    $order_data = json_decode($response, true);
    $pageOrders = $order_data['Items'] ?? [];
    if (!$pageOrders) break;

    $all_orders = array_merge($all_orders, $pageOrders);
    $page++;

} while (count($pageOrders) === $pageSize);

// === Prepare INSERT IGNORE Statements using SCID ===
foreach($all_orders as $orders){
	if($orders['ID']==" 5006551"){
		echo '<pre>';
print_r($orders);

	}
}
exit;
$orderStmt = $pdo->prepare("
    INSERT IGNORE INTO sellercloud_orders 
    (SCID, order_source_order_id, first_name, last_name, time_of_order, created_on, grand_total, customer_email, shipping_country, shipping_state, shipping_carrier, shipping_service)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
");

$itemStmt = $pdo->prepare("
    INSERT IGNORE INTO sellercloud_order_items 
    (SCID, product_id, display_name, qty, line_total, shipping_cost_accounting, ship_from_warehouse)
    VALUES (?, ?, ?, ?, ?, ?, ?)
");

$paymentStmt = $pdo->prepare("
    INSERT IGNORE INTO sellercloud_order_payments 
    (SCID, transaction_ref, paid_amount, payment_date, payment_type, payment_method, payment_status)
    VALUES (?, ?, ?, ?, ?, ?, ?)
");

$addressStmt = $pdo->prepare("
    INSERT IGNORE INTO sellercloud_order_addresses 
    (SCID, type, name_first, name_last, street1, street2, city, state, postal_code, country, phone, email)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
");

$bundleStmt = $pdo->prepare("
    INSERT IGNORE INTO sellercloud_bundle_items 
    (SCID, order_item_id, product_id, product_name, qty)
    VALUES (?, ?, ?, ?, ?)
");

$inserted = 0;

foreach ($all_orders as $o) {
    $scid = $o['ID'] ?? null;
    if (!$scid) continue;

    $orderStmt->execute([
        $scid, $o['OrderSourceOrderID'] ?? '', $o['FirstName'] ?? '', $o['LastName'] ?? '',
        $o['TimeOfOrder'] ?? null, $o['CreatedOn'] ?? null, $o['GrandTotal'] ?? 0,
        $o['CustomerEmail'] ?? '', $o['ShippingCountry'] ?? '', $o['ShippingState'] ?? '',
        $o['ShippingCarrier'] ?? '', $o['ShippingService'] ?? ''
    ]);
    if ($orderStmt->rowCount() > 0) $inserted++;

    foreach ($o['Items'] ?? [] as $i) {
        $itemStmt->execute([
            $scid, $i['ProductID'] ?? '', $i['DisplayName'] ?? '', $i['Qty'] ?? 0,
            $i['LineTotal'] ?? 0, $i['ShippingCostForAccounting'] ?? 0, $i['ShipFromWarehouseName'] ?? ''
        ]);

        foreach ($i['BundleItems'] ?? [] as $b) {
            $bundleStmt->execute([
                $scid, $i['ID'] ?? '', $b['ProductID'] ?? '', $b['ProductName'] ?? '', $b['Qty'] ?? 0
            ]);
        }
    }

    foreach ($o['Payments'] ?? [] as $p) {
        $paymentStmt->execute([
            $scid, $p['TransactionReferenceNumber'] ?? '', $p['PaidAmount'] ?? 0,
            $p['PaymentDate'] ?? null, $p['PaymentType'] ?? '', $p['PaymentMethod'] ?? '', $p['PaymentStatus'] ?? ''
        ]);
    }

    foreach ([['ShippingAddress', 'shipping'], ['BillingAddress', 'billing']] as [$type, $label]) {
        if (!empty($o[$type])) {
            $a = $o[$type];
            $addressStmt->execute([
                $scid, $label,
                $a['FirstName'] ?? '', $a['LastName'] ?? '', $a['StreetLine1'] ?? '', $a['StreetLine2'] ?? '',
                $a['City'] ?? '', $a['StateCode'] ?? '', $a['PostalCode'] ?? '', $a['CountryCode'] ?? '',
                $a['PhoneNumber'] ?? '', $a['EmailAddress'] ?? ''
            ]);
        }
    }
}

echo "✅ Inserted $inserted new orders (skipped existing).\n";
