<?php
// === Configuration ===
$username = 'dans@fcsus.com';
$password = '#PdC#M!9sP5T';
$orderId = 5006552;

// Define status update (e.g., Completed = 3)
$status_code = 2;

// Define note
$note_data = [
    "Message" => "Order marked complete. Loss column updated.",
    "Category" => 0,
    "IsPinned" => false
];

// Define custom columns
$custom_columns = [
    [
        "ColumnName" => "LOSS",
        "Value" => ["loss"]
    ]
];

// === Step 1: Authenticate ===
$auth_url = 'https://guru.api.sellercloud.us/rest/api/token';

$auth_payload = json_encode([
    'Username' => $username,
    'Password' => $password
]);

$auth_headers = ['Content-Type: application/json'];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $auth_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $auth_payload);
curl_setopt($ch, CURLOPT_HTTPHEADER, $auth_headers);
$response = curl_exec($ch);
$auth_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($auth_code !== 200) {
    die("❌ Auth failed. HTTP $auth_code\n$response\n");
}

$data = json_decode($response, true);
$access_token = $data['access_token'];
echo "✅ Authenticated.\n";

// === Step 2: Update Order Status ===
$status_url = 'https://guru.api.sellercloud.us/rest/api/Orders/StatusCode';
$status_payload = json_encode([
    "Orders" => [$orderId],
    "Status" => $status_code
]);

$headers = [
    "Content-Type: application/json",
    "Accept: application/json",
    "Authorization: Bearer $access_token"
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $status_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
curl_setopt($ch, CURLOPT_POSTFIELDS, $status_payload);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
$response = curl_exec($ch);
$status_http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($status_http === 200) {
    echo "✅ Status updated to $status_code for order $orderId.\n";
} else {
    echo "❌ Failed to update status. HTTP $status_http\n$response\n";
}

// === Step 3: Add Note ===
$note_url = "https://guru.api.sellercloud.us/rest/api/Orders/$orderId/Notes";
$note_payload = json_encode($note_data);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $note_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $note_payload);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
$response = curl_exec($ch);
$note_http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($note_http === 200 || $note_http === 201) {
    echo "✅ Note added to order $orderId.\n";
} else {
    echo "❌ Failed to add note. HTTP $note_http\n$response\n";
}

// === Step 4: Update Custom Columns ===
$column_url = "https://guru.api.sellercloud.us/rest/api/Orders/$orderId/CustomColumns/Multiple";
$column_payload = json_encode($custom_columns);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $column_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
curl_setopt($ch, CURLOPT_POSTFIELDS, $column_payload);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
$response = curl_exec($ch);
$column_http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($column_http === 200) {
    echo "✅ Custom column(s) updated for order $orderId.\n";
} else {
    echo "❌ Failed to update custom column(s). HTTP $column_http\n$response\n";
}
?>
